#ifndef __CXMLAttribute__
#define __CXMLAttribute__

#include "../Basics/CString.hpp"
using Exponent::Basics::CString;

namespace Exponent
{
	namespace IO
	{
		/**
		 * @class CXMLAttribute CXMLAttribute.hpp
		 * @brief Represents an xml attributes item
		 * @see CXMLNode
		 *
		 * @date 17/08/2005
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
		 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
		 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
		 * All content is the Intellectual property of Exp Digital Uk.\n
		 * Certain sections of this code may come from other sources. They are credited where applicable.\n
		 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
		 *
		 * $Id: CXMLAttribute.hpp,v 1.3 2007/02/08 21:06:44 paul Exp $
		 */
		class CXMLAttribute : public CCountedObject
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================
		
			/**
			 * Construction
			 * @param name The name of the attribute
			 * @param value The value of the attribute
			 */
			CXMLAttribute(const CString &name, const CString &value);

			/**
			 * Construction with boolean value
			 * @param name The name of the attribute
			 * @param value The value of the attribute
			 */
			CXMLAttribute(const CString &name, const bool value);

			/**
			 * Construction with boolean value
			 * @param name The name of the attribute
			 * @param value The value of the attribute
			 */
			CXMLAttribute(const CString &name, const double value);

			/**
			 * Construction with boolean value
			 * @param name The name of the attribute
			 * @param value The value of the attribute
			 */
			CXMLAttribute(const CString &name, const float value);

			/**
			 * Construction with boolean value
			 * @param name The name of the attribute
			 * @param value The value of the attribute
			 */
			CXMLAttribute(const CString &name, const long value);

			/**
			 * Construction with boolean value
			 * @param name The name of the attribute
			 * @param value The value of the attribute
			 */
			CXMLAttribute(const CString &name, const int value);

			/**
			 * Destruction
			 */
			virtual ~CXMLAttribute();

//	===========================================================================
			
			/**
			 * Set the name of the attribute
			 * @param name The name of the attribute
			 */
			void setName(const CString &name);

			/**
			 * Set the value of the attribute
			 * @param value The value of the attribute
			 */
			void setValue(const CString &value);

			/**
			 * Set the value of the attribute
			 * @param value The value of the attribute
			 */
			void setValue(const bool value);

			/**
			 * Set the value of the attribute
			 * @param value The value of the attribute
			 */
			void setValue(const double value);

			/**
			 * Set the value of the attribute
			 * @param value The value of the attribute
			 */
			void setValue(const float value);

			/**
			 * Set the value of the attribute
			 * @param value The value of the attribute
			 */
			void setValue(const long value);

			/**
			 * Set the value of the attribute
			 * @param value The value of the attribute
			 */
			void setValue(const int value);

//	===========================================================================
			
			/**
			 * Get the name of the attribute
			 * @retval const CString & The name of the attribute
			 */
			const CString &getName() const;
			
			/**
			 * Get the value of the attribute
			 * @retval const CString & The value of the attribute
			 */
			const CString &getValue() const;

//	===========================================================================

			/**
			 * Value as a double
			 * @retval double The value as a double
			 */
			double getValueAsDouble() const;

			/**
			 * Value as a float
			 * @retval float The value as a float
			 */
			float getValueAsFloat() const;

			/**
			 * Get the value as a long
			 * @retval long The value as a long
			 */
			long getValueAsLong() const;

			/**
			 * Get the value as an int
			 * @retval int The value as an int
			 */
			int getValueAsInt() const;

			/**
			 * Get the value as a bool
			 * @retval bool The value as a bool
			 */
			bool getValueAsBool() const;

//	===========================================================================
		
		protected:

//	===========================================================================
		
			CString m_name;		/**< Name of the attribute */
			CString m_value;	/**< Value of the attribute */
		};		
	}
}

#endif		// End of CXMLAttribute.hpp